#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

__constant float persp = 0.7f;
__constant float unzoom = 0.3f;
__constant float reflection = 0.4f;
__constant float floating = 3.0f;
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

static vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

static vec2 project (vec2 p) {
  return p * (vec2)(1.0f, -1.2f) + (vec2)(0.0f, -floating/100.f);
}

static bool inBounds (vec2 p) {
  return step(0.0f,p.x)*step(0.0f,p.y)*step(p.x, 1.0f)*step(p.y, 1.0f);
}

static vec4 bgColor (vec2 p, vec2 pfr, vec2 pto, __read_only image2d_t input1, __read_only image2d_t input2, __global FilterParam* param) 
{
  vec4 c = (vec4)(0.0f, 0.0f, 0.0f, 1.0f);
  
  pfr = project(pfr);
  if (inBounds(pfr)) {
    c += mix((vec4)(0.0f), INPUT(input1, param, pfr), reflection * mix(1.0f, 0.0f, pfr.y));
    if(pfr.y <= 0.01f)
    {
      float a = smoothstep(0.f, 0.01f, pfr.y);
	  c = mix((vec4)((vec3)(0.0f), 1.0f), c, a);
    }
  }
  pto = project(pto);
  if (inBounds(pto)) {
    c += mix((vec4)(0.0f), INPUT(input2, param, pto), reflection * mix(1.0f, 0.0f, pto.y));
	if(pto.y <= 0.01f)
    {
      float a = smoothstep(0.f, 0.01f, pto.y);
	  c = mix((vec4)((vec3)(0.0f), 1.0f), c, a);
    }
  }
  return c;
}

// p : the position
// persp : the perspective in [ 0, 1 ]
// center : the xcenter in [0, 1] \ 0.5 excluded
static vec2 xskew (vec2 p, float persp, float center) {
  float x = mix(p.x, 1.0f-p.x, center);
  return (
    (
      (vec2)( x, (p.y - 0.5f*(1.0f-persp) * x) / (1.0f+(persp-1.0f)*x) )
      - (vec2)(0.5f-fabs(center - 0.5f), 0.0f)
    )
    * (vec2)(0.5f / fabs(center - 0.5f) * (center<0.5f ? 1.0f : -1.0f), 1.0f)
    + (vec2)(center<0.5f ? 0.0f : 1.0f, 0.0f)
  );
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{

	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	vec2 op = uv;
	
	if(progress>0.99f)
	{
		write_imagef(dstImg, (int2)(w, textH - h -1),INPUT(input2, param, uv));
		return; 
	}
	
	float uz = unzoom * 2.0f*(0.5f-fabs(0.5f - progress));
	vec2 p = -uz*0.5f+(1.0f+uz) * op;
	vec2 fromP = xskew((p - (vec2)(progress, 0.0f)) / (vec2)(1.0f -progress, 1.0f), 1.0f - mix(progress, 0.0f, persp),0.0f);
	vec2 toP = xskew(p / (vec2)(progress, 1.0f),mix(pow(progress, 2.0f), 1.0f, persp),1.0f);
	
	vec4 gl_FragColor; 
	float a = 1.0f;
	if (inBounds(fromP)) {
		if (fromP.y >= 0.99f)
		{
			a = 1.0f - smoothstep(0.99f, 1.0f, fromP.y);
		}
		else if(fromP.y <= 0.01f)
		{
			a = smoothstep(0.f, 0.01f, fromP.y);
		}
		gl_FragColor = mix((vec4)((vec3)(0.0f), 1.0f), INPUT(input1, param, fromP), a);
	}else if (inBounds(toP)) {
		if (toP.y >= 0.99f)
		{
		  a = 1.0f - smoothstep(0.99f, 1.0f, toP.y);
		}
		else if(toP.y <= 0.01f)
		{
		  a = smoothstep(0.f, 0.01f, toP.y);
		}
		  gl_FragColor = mix((vec4)((vec3)(0.0f), 1.0f), INPUT(input2, param, toP),  a);
	}
	else {
		gl_FragColor = bgColor(op, fromP, toP, input1, input2, param);
	}
  write_imagef(dstImg, (int2)(w, textH - h -1),gl_FragColor);
}
